/*
 * @(#)ToggleButton.java  1.2.1  2003-04-18
 *
 * Copyright (c) 1999-2002 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Event;
import java.awt.Color;
import ch.randelshofer.gui.event.*;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
/**
 * Toggle button with six states: Unselected,
 * Unselected pressed, Unselected disabled, Selected, SelectedPressed, Selected disabled.
 *
 * @author	Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland.
 * @version	 1.2.1 2003-04-23 References to deprecated Java API's removed.
 * <br>1.1	1999-05-28	ButtonModel integrated into AbstractButton.
 * <br>1.0	1999-02-20	Created.
 */
public class ToggleButton
extends AbstractButton
implements ChangeListener {
    public ToggleButton() {
    }
    public void mouseReleased(java.awt.event.MouseEvent mouseEvent) {
        if ( isEnabled() && isArmed() ) { 
            setSelected( ! isSelected() ); 
        }
        super.mouseReleased(mouseEvent);
    }
}
